/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.mapgen.model.output;

import com.badlogic.gdx.math.GridPoint2;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.LongMap;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import technology.rocketjump.undermount.mapgen.generators.SimplexNoise;
import technology.rocketjump.undermount.mapgen.model.AbstractGameMap;
import technology.rocketjump.undermount.mapgen.model.FloorType;
import technology.rocketjump.undermount.mapgen.model.RoofType;
import technology.rocketjump.undermount.mapgen.model.VertexGameMap;
import technology.rocketjump.undermount.mapgen.model.output.GameMapTile;
import technology.rocketjump.undermount.mapgen.model.output.MapRegion;
import technology.rocketjump.undermount.mapgen.model.output.MapSubRegion;

public class GameMap
extends AbstractGameMap {
    private Array<Array<GameMapTile>> xArray;
    private VertexGameMap vertexGameMap;
    private final LongMap<MapRegion> regions = new LongMap();
    private final LongMap<MapSubRegion> subRegions = new LongMap();
    private List<GridPoint2> riverStartTiles = new LinkedList<GridPoint2>();
    private List<GridPoint2> riverEndTiles = new LinkedList<GridPoint2>();
    private List<GridPoint2> riverTiles = null;

    public GameMap(int width, int height) {
        super(width, height);
        this.xArray = new Array(width);
        for (int x = 0; x < width; ++x) {
            Array<GameMapTile> yArray = new Array<GameMapTile>(height);
            for (int y = 0; y < height; ++y) {
                yArray.add(new GameMapTile(new GridPoint2(x, y), this.isBorderTile(x, y, width, height)));
            }
            this.xArray.add(yArray);
        }
    }

    private boolean isBorderTile(int x, int y, int width, int height) {
        return x == 0 || y == 0 || x == width - 1 || y == height - 1;
    }

    public GameMapTile get(int x, int y) {
        if (x < 0 || x >= this.width) {
            return null;
        }
        if (y < 0 || y >= this.height) {
            return null;
        }
        return this.xArray.get(x).get(y);
    }

    public GameMapTile get(GridPoint2 position) {
        return this.get(position.x, position.y);
    }

    public void set(int x, int y, GameMapTile value) {
        this.xArray.get(x).set(y, value);
    }

    public GameMap clone() {
        GameMap cloned = new GameMap(this.width, this.height);
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                cloned.set(x, y, new GameMapTile(this.get(x, y)));
            }
        }
        cloned.setVertexGameMap(this.getVertexGameMap());
        return cloned;
    }

    public void addSimplexNoise(SimplexNoise simplexNoise) {
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                double noise = simplexNoise.getNoise(x, y);
                noise = (noise + 1.0) / 2.0;
                GameMapTile tile = this.get(x, y);
                tile.setNoisyHeightValue((float)(noise += (double)(tile.getHeightMapValue() / 2.0f)));
            }
        }
    }

    public void randomiseCaves(Random random) {
        int largestFeature = 70;
        double persistence = 0.7;
        SimplexNoise simplexNoise = new SimplexNoise(largestFeature, persistence, random);
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                GameMapTile tile = this.get(x, y);
                if (tile.getRoofType() != RoofType.Underground) continue;
                double noise = simplexNoise.getNoise(x, y);
                noise = (noise + 1.0) / 2.0;
                double chanceToBeCave = noise / 10.0 * 5.0 + (double)(tile.getHeightMapValue() / 10.0f * 5.0f);
                double averaged = noise / 10.0 * 6.0 + (double)(tile.getHeightMapValue() / 10.0f * 4.0f);
                if (!(averaged > 0.6)) continue;
                tile.setAsCave();
            }
        }
    }

    public void normaliseHeights() {
        int y;
        int x;
        float minHeight = Float.MAX_VALUE;
        float maxHeight = Float.MIN_VALUE;
        for (x = 0; x < this.width; ++x) {
            for (y = 0; y < this.height; ++y) {
                float heightAtPoint = this.get(x, y).getHeightMapValue();
                if (heightAtPoint < minHeight) {
                    minHeight = heightAtPoint;
                }
                if (!(heightAtPoint > maxHeight)) continue;
                maxHeight = heightAtPoint;
            }
        }
        for (x = 0; x < this.width; ++x) {
            for (y = 0; y < this.height; ++y) {
                GameMapTile tile = this.get(x, y);
                float heightAtPoint = tile.getHeightMapValue();
                float adjusted = (heightAtPoint - minHeight) / (maxHeight - minHeight) * 2.0f - 1.0f;
                tile.setHeightMapValue(adjusted);
            }
        }
    }

    public int getNumWallNeighbours(int x, int y) {
        int totalWallNeighbours = 0;
        if (this.isWallNeighbour(x - 1, y - 1)) {
            ++totalWallNeighbours;
        }
        if (this.isWallNeighbour(x, y - 1)) {
            ++totalWallNeighbours;
        }
        if (this.isWallNeighbour(x + 1, y - 1)) {
            ++totalWallNeighbours;
        }
        if (this.isWallNeighbour(x - 1, y)) {
            ++totalWallNeighbours;
        }
        if (this.isWallNeighbour(x + 1, y)) {
            ++totalWallNeighbours;
        }
        if (this.isWallNeighbour(x - 1, y + 1)) {
            ++totalWallNeighbours;
        }
        if (this.isWallNeighbour(x, y + 1)) {
            ++totalWallNeighbours;
        }
        if (this.isWallNeighbour(x + 1, y + 1)) {
            ++totalWallNeighbours;
        }
        return totalWallNeighbours;
    }

    private boolean isWallNeighbour(int x, int y) {
        GameMapTile neighbour = this.get(x, y);
        if (neighbour == null) {
            return false;
        }
        return neighbour.getFloorType() == FloorType.None;
    }

    public List<GameMapTile> getDiagonalNeighbours(GridPoint2 position) {
        GameMapTile SW;
        GameMapTile NW;
        GameMapTile SE;
        ArrayList<GameMapTile> neighbours = new ArrayList<GameMapTile>(4);
        GameMapTile NE = this.get(position.x + 1, position.y + 1);
        if (NE != null) {
            neighbours.add(NE);
        }
        if ((SE = this.get(position.x + 1, position.y - 1)) != null) {
            neighbours.add(SE);
        }
        if ((NW = this.get(position.x - 1, position.y + 1)) != null) {
            neighbours.add(NW);
        }
        if ((SW = this.get(position.x - 1, position.y - 1)) != null) {
            neighbours.add(SW);
        }
        return neighbours;
    }

    public List<GameMapTile> getOrthogonalNeighbours(GridPoint2 position) {
        GameMapTile right;
        GameMapTile left;
        GameMapTile down;
        ArrayList<GameMapTile> neighbours = new ArrayList<GameMapTile>(4);
        GameMapTile up = this.get(position.x, position.y + 1);
        if (up != null) {
            neighbours.add(up);
        }
        if ((down = this.get(position.x, position.y - 1)) != null) {
            neighbours.add(down);
        }
        if ((left = this.get(position.x - 1, position.y)) != null) {
            neighbours.add(left);
        }
        if ((right = this.get(position.x + 1, position.y)) != null) {
            neighbours.add(right);
        }
        return neighbours;
    }

    public LongMap<MapRegion> getRegions() {
        return this.regions;
    }

    public void addRegion(MapRegion region) {
        this.regions.put(region.getRegionId(), region);
    }

    public void addSubRegion(MapSubRegion subRegion) {
        this.subRegions.put(subRegion.getSubRegionId(), subRegion);
    }

    public Array<GameMapTile> getAllNeighbourTiles(int x, int y) {
        GameMapTile northWest;
        GameMapTile west;
        GameMapTile southWest;
        GameMapTile south;
        GameMapTile southEast;
        GameMapTile east;
        GameMapTile northEast;
        Array<GameMapTile> neighbours = new Array<GameMapTile>(8);
        GameMapTile north = this.get(x, y + 1);
        if (north != null) {
            neighbours.add(north);
        }
        if ((northEast = this.get(x + 1, y + 1)) != null) {
            neighbours.add(northEast);
        }
        if ((east = this.get(x + 1, y)) != null) {
            neighbours.add(east);
        }
        if ((southEast = this.get(x + 1, y - 1)) != null) {
            neighbours.add(southEast);
        }
        if ((south = this.get(x, y - 1)) != null) {
            neighbours.add(south);
        }
        if ((southWest = this.get(x - 1, y - 1)) != null) {
            neighbours.add(southWest);
        }
        if ((west = this.get(x - 1, y)) != null) {
            neighbours.add(west);
        }
        if ((northWest = this.get(x - 1, y + 1)) != null) {
            neighbours.add(northWest);
        }
        return neighbours;
    }

    public LongMap<MapSubRegion> getSubRegions() {
        return this.subRegions;
    }

    public void setRiver(List<GridPoint2> riverTiles) {
        this.riverTiles = riverTiles;
    }

    public boolean hasRiver() {
        return this.riverTiles != null;
    }

    public List<GridPoint2> getRiverTiles() {
        return this.riverTiles;
    }

    public List<GridPoint2> getRiverStartTiles() {
        return this.riverStartTiles;
    }

    public List<GridPoint2> getRiverEndTiles() {
        return this.riverEndTiles;
    }

    public VertexGameMap getVertexGameMap() {
        return this.vertexGameMap;
    }

    public void setVertexGameMap(VertexGameMap vertexGameMap) {
        this.vertexGameMap = vertexGameMap;
    }
}

